% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parModel.R
\name{ApplyFactory}
\alias{ApplyFactory}
\title{Configure the the execution model for gene evaluation.}
\usage{
ApplyFactory(method = "Sequential")
}
\arguments{
\item{method}{The label of the execution model: 
"Sequential" | "MultiCore" | 
"FutureApply" |  "Cluster".}
}
\value{
A function with the same result as the \code{lapply()}-function.
}
\description{
The current approach to distribution/parallelization of the genetic
algorithm is to parallelize the evaluation of the fitness function
only. The execution model defines the function \code{lF$lapply()}
used in the function \code{EvalPopulation()}.
}
\details{
Currently we support the following parallelization models:
\enumerate{
\item "Sequential": Uses \code{base::apply()}. (Default).
\item "MultiCore": Uses \code{parallel::mclapply()}. 
\item "FutureApply": Uses \code{future.apply::future_lapply()}
                   Plans must be set up and
                   worker processes must be stopped.
\item "Cluster": Uses \code{parallel:parLapply()}.
                   A cluster object must be set up and the 
                   worker processes must be stopped. 
}

The execution model \strong{"MultiCore"} provides parallelization restricted 
to a single computer: The master process starts R slave processes 
by fork() which are are run in separate memory spaces. 
At the time of fork() both memory spaces 
have the same content. Memory writes performed by one of the processes
do not affect the other. 

The execution model \strong{"FutureApply"} makes the possibilities 
of the future backends for a wide range of parallel and distributed 
architectures available.  
The models of parallel resolving a future use 
different types of communication between master 
and slaves: 
\enumerate{ 
\item \code{plan(sequential)} configures sequential execution. Default.

\item \code{w<-5; plan(multicore, workers=w)} configures an 
      asynchronous multicore execution of futures on 5 workers.
      
\item \code{w<-8; plan(multisession, workers=w)} configures a 
      multisession environment with 5 workers. 
      The evaluation of the future is done in parallel in 5 other 
      R sessions on the same machine. 
      Communication is done via socket connections, 
      the R sessions started serve multiple futures over their life time.
      The worker R sessions are stopped by calling \code{plan(sequential)}.
      The number of parallel sessions is restricted by the availability
      of connections. Up to R version 4.3, 
      a maximum of 125 connections is available.

\item \code{w<-7; plan(callr, workers=w)} configures  
      the evaluation of futures on top of the \code{callr} package.
      The \code{callr} package creates for each future a separate R session.
      The communications is via files of serialized R objects.
      The advantages of \code{callr} are:
      \enumerate{  
      \item Each \code{callr} future is evaluated in a new R session
            which ends as soon as the value of the future has been 
            collected.
      \item The number of parallel \code{callr} futures is not restricted
            by the number of available connections, because the 
            communication is based on files of serialized R objects.
      \item No ports are used. This means no port clashes with other 
            processes and no firewall issues.
      }

\item Setting up a cluster environment for resolving futures works
      as follows. Write a function with the following elements:
      \enumerate{
      \item Generate a cluster object:

       \code{cl<-makeClusterPSOCK(rep("localhost", workers)} 
      \item Set up an on.exit condition for stopping the worker processes.

      \code{on.exit(parallel::stopCluster(cl))}
      \item Set up the plan for resolving the future:

      \code{oldplan<-plan(cluster, workers=cl)}
      \item Call the function with \code{future.apply::future_lapply}.
            E.g. the genetic algorithm.
      \item Restore the previous plan:
      \code{plan(oldplan)}
      }
      The cluster processes may be located on one or several computers.
      The communication between the processes is via sockets.
      Remote computers must allow the use of ssh to start R-processes
      without an interactive login.
}

The execution model \strong{"Cluster"} allows the configuration of 
master-slave processing on local and remote machines.
}
\seealso{
Other Configuration: 
\code{\link{AcceptFactory}()},
\code{\link{CoolingFactory}()},
\code{\link{CrossRateFactory}()},
\code{\link{MutationRateFactory}()},
\code{\link{xegaConfiguration}()}
}
\concept{Configuration}
