% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{download_file}
\alias{download_file}
\title{Try various methods to download a file}
\usage{
download_file(url, output = basename(url), ...)
}
\arguments{
\item{url}{The URL of the file.}

\item{output}{Path to the output file. If not provided, the base name of the
URL will be used (query parameters and hash in the URL will be removed).}

\item{...}{Other arguments to be passed to \code{\link{download.file}()}
(except \code{method}).}
}
\value{
The integer code \code{0} for success, or an error if none of the
  methods work.
}
\description{
Try all possible methods in \code{\link{download.file}()} (e.g.,
\code{libcurl}, \code{curl}, \code{wget}, and \code{wininet}) and see if any
method can succeed. The reason to enumerate all methods is that sometimes the
default method does not work, e.g.,
\url{https://stat.ethz.ch/pipermail/r-devel/2016-June/072852.html}.
}
