% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_dirs2char.R
\name{xgx_dirs2char}
\alias{xgx_dirs2char}
\title{Append filenames to bottom of the plot}
\usage{
xgx_dirs2char(dirs, include_time = TRUE)
}
\arguments{
\item{dirs}{list containing directories and filenames.  It must contain 
five fields
\enumerate{
\item parent_dir  = Parent directory containing the Rscript and the Results 
folder
\item rscript_dir = Subdirectory ofparent_dir that contains the Rscript 
used to generate the figure
\item rscript_name= Name of the Rscript used to generate the figure
\item results_dir = Subdirectory ofparent_dir where the figure is stored
\item filename    = Filename
}}

\item{include_time}{is logical with default TRUE.  If TRUE, it includes 
date / time in the output character}
}
\value{
character
}
\description{
\code{xgx_dirs2char} returns a character variable based on the dirs list.
The caption gives the filename
}
\examples{
dirs <- list(parent_dir = "/your/parent/path/",
            rscript_dir = "./Rscripts/",
            rscript_name = "Example.R",
            results_dir = "./Results/",
            filename = "your_file_name.png")
caption <- xgx_dirs2char(dirs)

}
