% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NamedRanges.R
\name{NamedRanges}
\alias{NamedRanges}
\alias{createRange}
\alias{getRanges}
\alias{readRange}
\title{Functions to manipulate (contiguous) named ranges.}
\usage{
createRange(rangeName, firstCell, lastCell)

getRanges(wb)

readRange(range, sheet, colClasses = "character")
}
\arguments{
\item{rangeName}{a character specifying the name of the name to create.}

\item{firstCell}{a cell object corresponding to the top left cell in the
range.}

\item{lastCell}{a cell object corresponding to the bottom right cell in the
range.}

\item{wb}{a workbook object as returned by \code{createWorksheet} or
\code{loadWorksheet}.}

\item{range}{a range object as returned by \code{getRanges}.}

\item{sheet}{a sheet object as returned by \code{getSheets}.}

\item{colClasses}{the type of the columns supported.  Only \code{numeric}
and \code{character} are supported.  See \code{\link{read.xlsx2}} for more
details.}
}
\value{
\code{getRanges} returns the existing ranges as a list.

\code{readRange} reads the range into a data.frame.

\code{createRange} returns the created range object.
}
\description{
These functions are provided for convenience only.  Use directly the Java
API to access additional functionality.
}
\examples{


file <- system.file("tests", "test_import.xlsx", package = "xlsx")

wb <- loadWorkbook(file)
sheet <- getSheets(wb)[["deletedFields"]]
ranges <- getRanges(wb)

# the call below fails on cran tests for MacOS.  You should see the
# FAQ: http://code.google.com/p/rexcel/wiki/FAQ
#res  <- readRange(ranges[[1]], sheet, colClasses="numeric") # read it

ranges[[1]]$getNameName()  # get its name

# see all the available java methods that you can call
rJava::.jmethods(ranges[[1]])

# create a new named range
firstCell <- sheet$getRow(14L)$getCell(4L)
lastCell  <- sheet$getRow(20L)$getCell(7L)
rangeName <- "Test2"
# same issue on MacOS
#createRange(rangeName, firstCell, lastCell)


}
\author{
Adrian Dragulescu
}
