% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_descriptors.R
\name{element_types}
\alias{element_types}
\title{Gets the type of each element}
\usage{
element_types(x, keep_names = FALSE)
}
\arguments{
\item{x}{List with elements.}

\item{keep_names}{Whether to keep names. (Logical)}
}
\value{
The type of each element.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Applies \code{\link[base:typeof]{typeof()}} to each element of \code{x} (without recursion).
}
\details{
Simple wrapper for \code{unlist(lapply(x, typeof))}.
}
\examples{
# Attach packages
library(xpectr)

l <- list("a" = c(1,2,3), "b" = "a", "c" = NULL)

element_types(l)
element_types(l, keep_names = TRUE)
}
\seealso{
Other element descriptors: 
\code{\link{element_classes}()},
\code{\link{element_lengths}()},
\code{\link{num_total_elements}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{element descriptors}
