% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixes.R
\name{summarise_xpdb}
\alias{summarise_xpdb}
\alias{group_by_x}
\alias{ungroup_x}
\title{Group/ungroup and summarize variables in an xpdb}
\usage{
group_by_x(.data, ..., .problem, .source, .where)

ungroup_x(.data, ..., .problem, .source, .where)
}
\arguments{
\item{.data}{An xpose database object.}

\item{...}{Name-value pairs of expressions. Use \code{NULL} to drop a variable.}

\item{.problem}{The problem from which the data will be modified}

\item{.source}{The source of the data in the xpdb. Can either be 'data' or an output
file extension e.g. 'phi'.}

\item{.where}{A vector of element names to be edited in special (e.g.
\code{.where = c('vpc_dat', 'aggr_obs')} with vpc).}
}
\value{
Group data in an \code{xpose} data object
}
\description{
\code{group_by_x()} takes an existing table and converts it into a
grouped table where operations are performed "by group". \code{ungroup()} removes grouping.
\code{summarize()} reduces multiple values down to a single value.

\strong{Note:} this function uses \code{xpose.xtras::edit_xpose_data}, but is otherwise
the same as <\code{\link[xpose:reexports]{xpose::group_by}}>.
}
