% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpdb_access.R
\name{get_file}
\alias{get_file}
\title{Access model output file data}
\usage{
get_file(
  xpdb,
  file = NULL,
  ext = NULL,
  .problem = NULL,
  .subprob = NULL,
  .method = NULL,
  quiet
)
}
\arguments{
\item{xpdb}{An \code{xpose_data} object from which the model output file data will be extracted.}

\item{file}{Full name of the file to be extracted from the xpdb e.g. 'run001.phi'. Alternative to the 'ext' argument.}

\item{ext}{Extension of the file to be extracted from the xpdb e.g. 'phi'. Alternative to the 'file' argument.}

\item{.problem}{The problem to be used, by default returns the last one for each file.}

\item{.subprob}{The subproblem to be used, by default returns the last one for each file.}

\item{.method}{The estimation method to be used (e.g. 'foce', 'imp', 'saem'), by default returns the 
last one for each file.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}
}
\value{
A tibble for single file or a named list for multiple files.
}
\description{
Access model output file data from an xpdb object.
}
\examples{
# Single file (returns a tibble)
ext_file <- get_file(xpdb_ex_pk, file = 'run001.ext')
ext_file

# Multiple files (returns a list)
files <- get_file(xpdb_ex_pk, file = c('run001.ext', 'run001.phi'))
files

# Tip to list available files in the xpdb
print(xpdb_ex_pk)

}
\seealso{
\code{\link{list_files}}, \code{\link{xpose_data}}, \code{\link{read_nm_files}}
}
