% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_individuals.R
\name{ind_plots}
\alias{ind_plots}
\title{Observations, individual predictions and population predictions plotted against 
the independent variable for every individual}
\usage{
ind_plots(
  xpdb,
  mapping = NULL,
  group = "variable",
  type = "lp",
  title = "Individual plots | @run",
  subtitle = "Ofv: @ofv, Eps shrink: @epsshk",
  caption = "@dir | Page @page of @lastpage",
  tag = NULL,
  log = NULL,
  facets,
  .problem,
  quiet,
  color = c("grey60", "deepskyblue4", "deepskyblue3"),
  point_alpha = c(0.8, 0, 0),
  line_linetype = c("blank", "solid", "55"),
  ...
)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{mapping}{List of aesthetics mappings to be used for the xpose plot 
(e.g. \code{point_color}).}

\item{group}{Grouping variable to be used for lines.}

\item{type}{String setting the type of plot to be used. Can be points 'p',
line 'l', smooth 's' and text 't' or any combination of the four.}

\item{title}{Plot title. Use \code{NULL} to remove.}

\item{subtitle}{Plot subtitle. Use \code{NULL} to remove.}

\item{caption}{Page caption. Use \code{NULL} to remove.}

\item{tag}{Plot identification tag. Use \code{NULL} to remove.}

\item{log}{String assigning logarithmic scale to axes, can be either '', 
'x', y' or 'xy'.}

\item{facets}{Either a character string to use \code{\link[ggforce]{facet_wrap_paginate}}
or a formula to use \code{\link[ggforce]{facet_grid_paginate}}.}

\item{.problem}{The $problem number to be used. By default returns 
the last estimation problem.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}

\item{color}{Changes the **lines, points and text** color. Should be a vector of 3 values 
(i.e. DV, IPRED, PRED). This \code{color} argument is a special case in xpose as it applies 
to three different layers (\code{geom_line}, \code{geom_point} and \code{geom_text}). This 
special case is due to the fact that in ggplot2 it is not possible to have two different 
color scales for different layers.}

\item{point_alpha}{Points alpha, should be a vector of 3 values (i.e. DV, IPRED, PRED).}

\item{line_linetype}{Lines linetype, should be a vector of 3 values (i.e. DV, IPRED, PRED).}

\item{...}{Any additional aesthetics to be passed on \code{xplot_scatter}.}
}
\description{
Observations (DV), individual predictions (IPRED) and population predictions 
(PRED) plotted against the independent variable for every individual
}
\section{Layers mapping}{

Plots can be customized by mapping arguments to specific layers. The naming convention is 
layer_option where layer is one of the names defined in the list below and option is 
any option supported by this layer e.g. point_color = 'blue', smooth_method = 'lm', etc.
\itemize{
  \item point: options to \code{geom_point}
  \item line: options to \code{geom_line}
  \item guide: options to \code{geom_abline}
  \item smooth: options to \code{geom_smooth}
  \item text: options to \code{geom_text}
  \item xscale: options to \code{scale_x_continuous} or \code{scale_x_log10}
  \item yscale: options to \code{scale_y_continuous} or \code{scale_y_log10}
}
}

\section{Faceting}{

Every xpose plot function has built-in faceting functionalities. Faceting arguments 
are passed to the functions \code{\link[ggforce]{facet_wrap_paginate}} when the \code{facets} 
argument is a character string (e.g. \code{facets = c('SEX', 'MED1')}) or 
\code{\link[ggforce]{facet_grid_paginate}} when facets is a formula (e.g. \code{facets = SEX~MED1}).
All xpose plot functions accept all the arguments for the \code{\link[ggforce]{facet_wrap_paginate}} 
and \code{\link[ggforce]{facet_grid_paginate}} functions e.g. \code{dv_vs_ipred(xpdb_ex_pk, 
facets = SEX~MED1, ncol = 3, nrow = 3, page = 1, margins = TRUE, labeller = 'label_both')}.

Faceting options can either be defined in plot functions (e.g. \code{dv_vs_ipred(xpdb_ex_pk, 
facets = 'SEX')}) or assigned globally to an xpdb object via the \code{xp_theme} (e.g. \code{xpdb 
<- update_themes(xpdb_ex_pk, xp_theme = list(facets = 'SEX'))}). In the latter example all plots 
generate from this xpdb will automatically be stratified by `SEX`.

By default, some plot functions use a custom stratifying variable named `variable`, e.g. 
\code{eta_distrib()}. When using the \code{facets} argument, `variable` needs to be added manually 
e.g. \code{facets = c('SEX', 'variable')} or \code{facets = c('SEX', 'variable')}, but is optional, 
when using the \code{facets} argument in \code{xp_theme} variable is automatically added whenever needed.
}

\section{Template titles}{

Template titles can be used to create highly informative diagnostics plots. 
They can be applied to any plot title, subtitle, caption and tag. Template titles 
are defined via a single string containing key variables staring with a `@` (e.g. `@ofv`)
which will be replaced by their actual value when rendering the plot.
For example `'@run, @nobs observations in @nind subjects'` would become 
`'run001, 1022 observations in 74 subjects'`. The available key variables 
are listed under \code{\link{template_titles}}.
}

\examples{
\dontrun{
# Basic example
ind_plots(xpdb_ex_pk, page = 1,
          ncol = 2, nrow = 2)
}
}
\seealso{
\code{\link{xplot_scatter}}
}
