% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose.VPC.R
\name{xpose.VPC}
\alias{xpose.VPC}
\title{Visual Predictive Check (VPC) using XPOSE}
\usage{
xpose.VPC(
  vpc.info = "vpc_results.csv",
  vpctab = dir(pattern = "^vpctab")[1],
  object = NULL,
  ids = FALSE,
  type = "p",
  by = NULL,
  PI = NULL,
  PI.ci = "area",
  PI.ci.area.smooth = FALSE,
  PI.real = TRUE,
  subset = NULL,
  main = "Default",
  main.sub = NULL,
  main.sub.cex = 0.85,
  inclZeroWRES = FALSE,
  force.x.continuous = FALSE,
  funy = NULL,
  logy = FALSE,
  ylb = "Default",
  verbose = FALSE,
  PI.x.median = TRUE,
  PI.rug = "Default",
  PI.identify.outliers = TRUE,
  ...
)
}
\arguments{
\item{vpc.info}{The results file from the \code{vpc} command in PsN. for 
example \file{vpc_results.csv}, or if the file is in a separate directory 
\file{./vpc_dir1/vpc_results.csv}.}

\item{vpctab}{The \file{vpctab} from the \code{vpc} command in PsN.  For 
example \file{vpctab5}, or if the file is in a separate directory 
\file{./vpc_dir1/vpctab5}.  Can be \code{NULL}.  The default looks in the 
current working directory and takes the first file that starts with 
\file{vpctab} that it finds.  Note that this default can result in the 
wrong files being read if there are multiple \file{vpctab} files in the 
directory. One of \code{object} or \code{vpctab} is required.  If both are 
present then the information from the \code{vpctab} will over-ride the 
xpose data object \code{object} (i.e. the values from the vpctab will 
replace any matching values in the \code{object\@Data} portion of the xpose
data object).}

\item{object}{An xpose data object. Created from \code{\link{xpose.data}}. 
One of \code{object} or \code{vpctab} is required.  If both are present 
then the information from the \code{vpctab} will over-ride the xpose data 
object \code{object} (i.e. the values from the vpctab will replace any 
matching values in the \code{object\@Data} portion of the xpose data 
object).}

\item{ids}{A logical value indicating whether text ID labels should be used 
as plotting symbols (the variable used for these symbols indicated by the 
\code{idlab} xpose data variable). Can be \code{FALSE} or \code{TRUE}.}

\item{type}{Character string describing the way the points in the plot will 
be displayed. For more details, see \code{\link[graphics]{plot}}. Use 
\code{type="n"} if you don't want observations in the plot.}

\item{by}{A string or a vector of strings with the name(s) of the 
conditioning variables. For example \code{by = c("SEX","WT")}.  Because the
function automatically determines the conditioning variable from the PsN 
input file specified in \code{vpc.info}, the \code{by} command can control 
if separate plots are created for each condition (\code{by=NULL}), or if a 
conditioning plot should be created (\code{by="WT"} for example).  If the 
\code{vpc.info} file has a conditioning variable then \code{by} must match 
that variable.  If there is no conditioning variable in \code{vpc.info} 
then the \code{PI} for each conditioned plot will be the \code{PI} for the 
entire data set (not only for the conditioning subset).}

\item{PI}{Either "lines", "area" or "both" specifying whether prediction 
intervals (as lines, a shaded area or both) should be added to the plot. 
\code{NULL} means no prediction interval.}

\item{PI.ci}{Plot the confidence interval for the simulated data's
percentiles for each bin (for each simulated data set compute the
percentiles for each bin, then, from all of the percentiles from all of the
simulated datasets compute the 95\% CI of these percentiles). Values can be
\code{"both"}, \code{"area"} or \code{"lines"}. These CIs can be used to
asses the \code{PI.real} values for model misspecification. Note that with
few observations per bin the CIs will be approximate because the 
percentiles in each bin will be approximate. For example, the 95th 
percentile of 4 data points will always be the largest of the 4 data 
points.}

\item{PI.ci.area.smooth}{Should the "area" for \code{PI.ci} be smoothed to
match the "lines" argument? Allowed values are \code{TRUE/FALSE}. The "area"
is set by default to show the bins used in the \code{PI.ci} computation.  By
smoothing, information is lost and, in general, the confidence intervals
will be smaller than they are in reality.}

\item{PI.real}{Plot the percentiles of the real data in the various bins. 
values can be NULL or TRUE.  Note that for a bin with few actual 
observations the percentiles will be approximate.  For example, the 95th 
percentile of 4 data points will always be the largest of the 4 data 
points.}

\item{subset}{A string giving the subset expression to be applied to the data
before plotting. See \code{\link{xsubset}}.}

\item{main}{A string giving the plot title or \code{NULL} if none. 
\code{"Default"} creates a default title.}

\item{main.sub}{Used for names above each plot when using multiple plots. 
Should be a vector \code{c("Group 1","Group 2")}}

\item{main.sub.cex}{The size of the \code{main.sub} titles.}

\item{inclZeroWRES}{Logical value indicating whether rows with WRES=0 is 
included in the plot.}

\item{force.x.continuous}{Logical value indicating whether x-values should be
converted to continuous variables, even if they are defined as factors.}

\item{funy}{String of function to apply to Y data. For example "abs"}

\item{logy}{Logical value indicating whether the y-axis should be 
logarithmic, base 10.}

\item{ylb}{Label for the y-axis}

\item{verbose}{Should warning messages and other diagnostic information be 
passed to screen? (TRUE or FALSE)}

\item{PI.x.median}{Should the x-location of percentile lines in a bin be 
marked at the median of the x-values? (\code{TRUE} or \code{FALSE})}

\item{PI.rug}{Should there be markings on the plot showing where the binning intervals 
for the VPC are 
(or the locations of the independent variable used for each VPC calculation if binning is not used)?}

\item{PI.identify.outliers}{Should outlying percentiles of the real data be highlighted? (TRUE of FALSE)}

\item{\dots}{Other arguments passed to \code{\link{xpose.panel.default}}, 
\code{\link{xpose.plot.default}} and others. Please see these functions for
more descriptions of what you can do.}
}
\value{
A plot or a list of plots.
}
\description{
This Function is used to create a VPC in xpose using the output from the 
\code{vpc} command in Pearl Speaks NONMEM (PsN).  The function reads in the 
output files created by PsN and creates a plot from the data.  The dependent 
variable, independent variable and conditioning variable are automatically 
determined from the PsN files.
}
\section{Additional arguments}{

  
  Below are some of the additional arguments that can control the look and 
  feel of the VPC.  See 
  \code{\link{xpose.panel.default}} for all potential options.
  
  \strong{Additional graphical elements available in the VPC plots.\cr}
  
  \describe{
  
  \item{ PI.mirror = NULL, TRUE or AN.INTEGER.VALUE}{Plot the percentiles of 
  one simulated data set in each bin. \code{TRUE} takes the first mirror from
  \file{vpc_results.csv} and \code{AN.INTEGER.VALUE} can be \code{1, 2, 
  \dots{} n} where \code{n} is the number of mirror's output in the 
  \file{vpc_results.csv} file.} 
  \item{ PI.limits = c(0.025, 0.975)}{A vector of two 
  values that describe the limits of the prediction interval that should be 
  displayed.  These limits should be found in the \file{vpc_results.csv} 
  file. These limits are also used as the percentages for the \code{PI.real, 
  PI.mirror} and \code{PI.ci}.  However, the confidence interval in 
  \code{PI.ci} is always the one defined in the \file{vpc_results.csv} file.}
  }
  
  \strong{Additional options to control the look and feel of the \code{PI}. 
  See See \code{\link[grid]{grid.polygon}} and \code{\link[graphics]{plot}} 
  for more details.\cr}
  
  \describe{ \item{ PI.arcol}{The color of the \code{PI} area} \item{ 
  PI.up.lty}{The upper line type. can be "dotted" or "dashed", etc.} \item{ 
  PI.up.type}{The upper type used for plotting.  Defaults to a line.} \item{ 
  PI.up.col}{The upper line color} \item{ PI.up.lwd}{The upper line width} 
  \item{ PI.down.lty}{The lower line type. can be "dotted" or "dashed", etc.}
  \item{ PI.down.type}{The lower type used for plotting. Defaults to a line.}
  \item{ PI.down.col}{The lower line color} \item{ PI.down.lwd}{The lower 
  line width} \item{ PI.med.lty}{The median line type. can be "dotted" or 
  "dashed", etc.} \item{ PI.med.type}{The median type used for plotting. 
  Defaults to a line.} \item{ PI.med.col}{The median line color} \item{ 
  PI.med.lwd}{The median line width} }
  
  \strong{Additional options to control the look and feel of the 
  \code{PI.ci}. See See \code{\link[grid]{grid.polygon}} and 
  \code{\link[graphics]{plot}} for more details.\cr}
  
  \describe{ \item{ PI.ci.up.arcol}{The color of the upper \code{PI.ci}.} 
  \item{ PI.ci.med.arcol}{The color of the median \code{PI.ci}.} \item{ 
  PI.ci.down.arcol}{The color of the lower \code{PI.ci}.} \item{ 
  PI.ci.up.lty}{The upper line type. can be "dotted" or "dashed", etc.} 
  \item{ PI.ci.up.type}{The upper type used for plotting.  Defaults to a 
  line.} \item{ PI.ci.up.col}{The upper line color} \item{ PI.ci.up.lwd}{The 
  upper line width} \item{ PI.ci.down.lty}{The lower line type. can be 
  "dotted" or "dashed", etc.} \item{ PI.ci.down.type}{The lower type used for
  plotting.  Defaults to a line.} \item{ PI.ci.down.col}{The lower line 
  color} \item{ PI.ci.down.lwd}{The lower line width} \item{ 
  PI.ci.med.lty}{The median line type. can be "dotted" or "dashed", etc.} 
  \item{ PI.ci.med.type}{The median type used for plotting.  Defaults to a 
  line.} \item{ PI.ci.med.col}{The median line color} \item{ 
  PI.ci.med.lwd}{The median line width} \item{PI.ci.area.smooth}{Should the 
  "area" for \code{PI.ci} be smoothed to match the "lines" argument? Allowed 
  values are \code{TRUE/FALSE}. The "area" is set by default to show the bins
  used in the \code{PI.ci} computation.  By smoothing, information is lost 
  and, in general, the confidence intervals will be smaller than they are in 
  reality.} }
  
  \strong{Additional options to control the look and feel of the 
  \code{PI.real}. See See \code{\link[grid]{grid.polygon}} and 
  \code{\link[graphics]{plot}} for more details.\cr}
  
  \describe{ \item{ PI.real.up.lty}{The upper line type. can be "dotted" or 
  "dashed", etc.} \item{ PI.real.up.type}{The upper type used for plotting. 
  Defaults to a line.} \item{ PI.real.up.col}{The upper line color} \item{ 
  PI.real.up.lwd}{The upper line width} \item{ PI.real.down.lty}{The lower 
  line type. can be "dotted" or "dashed", etc.} \item{ PI.real.down.type}{The
  lower type used for plotting.  Defaults to a line.} \item{ 
  PI.real.down.col}{The lower line color} \item{ PI.real.down.lwd}{The lower 
  line width} \item{ PI.real.med.lty}{The median line type. can be "dotted" 
  or "dashed", etc.} \item{ PI.real.med.type}{The median type used for 
  plotting.  Defaults to a line.} \item{ PI.real.med.col}{The median line 
  color} \item{ PI.real.med.lwd}{The median line width} }
  
  \strong{Additional options to control the look and feel of the 
  \code{PI.mirror}. See See \code{\link[graphics]{plot}} for more 
  details.\cr}
  
  \describe{ \item{PI.mirror.up.lty}{The upper line type. can be "dotted" or 
  "dashed", etc.} \item{ PI.mirror.up.type}{The upper type used for plotting.
  Defaults to a line.} \item{ PI.mirror.up.col}{The upper line color} \item{ 
  PI.mirror.up.lwd}{The upper line width} \item{ PI.mirror.down.lty}{The 
  lower line type. can be "dotted" or "dashed", etc.} \item{ 
  PI.mirror.down.type}{The lower type used for plotting.  Defaults to a 
  line.} \item{ PI.mirror.down.col}{The lower line color} \item{ 
  PI.mirror.down.lwd}{The lower line width} \item{ PI.mirror.med.lty}{The 
  median line type. can be "dotted" or "dashed", etc.} \item{ 
  PI.mirror.med.type}{The median type used for plotting.  Defaults to a 
  line.} \item{ PI.mirror.med.col}{The median line color} \item{ 
  PI.mirror.med.lwd}{The median line width} }
}

\examples{

\dontrun{
library(xpose4)

xpose.VPC()

## to be more clear about which files should be read in
vpc.file <- "vpc_results.csv"
vpctab <- "vpctab5"
xpose.VPC(vpc.info=vpc.file,vpctab=vpctab)

## with lines and a shaded area for the prediction intervals
xpose.VPC(vpc.file,vpctab=vpctab,PI="both")

## with the percentages of the real data
xpose.VPC(vpc.file,vpctab=vpctab,PI.real=T)

## with mirrors (if supplied in 'vpc.file')
xpose.VPC(vpc.file,vpctab=vpctab,PI.real=T,PI.mirror=5)

## with CIs
xpose.VPC(vpc.file,vpctab=vpctab,PI.real=T,PI.ci="area")
xpose.VPC(vpc.file,vpctab=vpctab,PI.real=T,PI.ci="area",PI=NULL)

## stratification (if 'vpc.file' is stratified)
cond.var <- "WT"
xpose.VPC(vpc.file,vpctab=vpctab)
xpose.VPC(vpc.file,vpctab=vpctab,by=cond.var)
xpose.VPC(vpctab=vpctab,vpc.info=vpc.file,PI="both",by=cond.var,type="n")

## with no data points in the plot
xpose.VPC(vpc.file,vpctab=vpctab,by=cond.var,PI.real=T,PI.ci="area",PI=NULL,type="n")

## with different DV and IDV, just read in new files and plot
vpc.file <- "vpc_results.csv"
vpctab <- "vpctab5"
cond.var <- "WT"
xpose.VPC(vpctab=vpctab,vpc.info=vpc.file,PI="both",by=cond.var)
xpose.VPC(vpctab=vpctab,vpc.info=vpc.file,PI="both")

## to use an xpose data object instead of vpctab
##
## In this example
## we expect to find the required NONMEM run and table files for run
## 5 in the current working directory
runnumber <- 5
xpdb <- xpose.data(runnumber)
xpose.VPC(vpc.file,object=xpdb)

## to read files in a directory different than the current working directory 
vpc.file <- "./vpc_strat_WT_4_mirror_5/vpc_results.csv"
vpctab <- "./vpc_strat_WT_4_mirror_5/vpctab5"
xpose.VPC(vpc.info=vpc.file,vpctab=vpctab)

## to rearrange order of factors in VPC plot
xpdb@Data$SEX <- factor(xpdb@Data$SEX,levels=c("2","1"))
xpose.VPC(by="SEX",object=xpdb)

}


}
\seealso{
\code{\link{read.vpctab}} \code{\link{read.npc.vpc.results}} 
  \code{\link{xpose.panel.default}} \code{\link{xpose.plot.default}}

Other PsN functions: 
\code{\link{boot.hist}()},
\code{\link{bootscm.import}()},
\code{\link{npc.coverage}()},
\code{\link{randtest.hist}()},
\code{\link{read.npc.vpc.results}()},
\code{\link{read.vpctab}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres_wres_vs_x}},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}
}
\author{
Andrew Hooker
}
\concept{PsN functions}
\concept{specific functions}
\keyword{methods}
