\name{period.apply}
\alias{period.apply}
\title{ Apply Function Over Specified Interval }
\description{
Apply a specified function to data over a given
interval, where the interval is taken to be
the data from INDEX[k] to INDEX[k+1], for
k=1:(length(INDEX)-1).
}
\usage{
period.apply(x, INDEX, FUN, ...)
}
\arguments{
  \item{x}{ data to apply FUN to }
  \item{INDEX}{ numeric vector specifying indexing }
  \item{FUN}{ an argument of type \code{function} }
  \item{\dots}{ additional arguments for \code{FUN}}
}
\details{
Similar to the rest of the apply family, calculate
a specified functions value given a shifting set
of data values. The primary difference is that it
is that \code{period.apply} applies a function to non-overlapping
intervals along a vector.

Useful for applying arbitrary functions over
an entire data object by an aribirtary index,
as when INDEX is the result of a call
to breakpoints.
}
\value{
A vector with length of INDEX minus 1
}
\author{ Jeffrey A. Ryan }
\seealso{ \code{\link{endpoints}} \code{\link{apply.monthly}}}
\examples{
zoo.data <- zoo(rnorm(31)+10,as.Date(13514:13744,origin="1970-01-01"))
ep <- endpoints(zoo.data,'weeks')
period.apply(zoo.data, INDEX=ep, FUN=function(x) sd(x))
period.apply(zoo.data, INDEX=ep, FUN=sd)                  #same

glue <- function(x) { paste(x,collapse='') }
period.apply(letters,c(0,5,7,26),glue)
}
\keyword{ utilities }% __ONLY ONE__ keyword per line
