% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module1_irt_utils.R
\name{irt_stats}
\alias{irt_stats}
\title{Compute IRT Statistics}
\usage{
irt_stats(x, stats = c("prob", "info", "lik", "loglik"), summary = NULL,
  fun = NULL, ...)
}
\arguments{
\item{x}{an IRT model object}

\item{stats}{the statistic to be computed}

\item{summary}{the summarization direction}

\item{fun}{the summarization function}

\item{...}{other optional arguments}
}
\description{
Compute probability, information, likelihood and loglikelihood via a common interface
}
\details{
In \code{irt_stats}, use \code{stats="prob"} to compute probility, \code{stats="info"} to compute information,
\code{stats="lik"} to compute likelihood, and \code{stats="loglik"} to compute log-likelihood. 
Use \code{summary="people"} to summarize results over items and \code{summary="items"} to summarize results over people.\cr
}
\examples{
 
# Compute prob(ability), info(rmation), lik(elihood) and loglik(elihood)
x <- irt_model("3pl")$gendata(20, 5)
irt_stats(x, "prob")
irt_stats(x, "prob", "people", sum)
irt_stats(x, "info")
irt_stats(x, "info", "items", sum)
irt_stats(x, "lik")
irt_stats(x, "loglik")
}

