% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module0_model_3pl.R
\name{model_3pl}
\alias{model_3pl}
\alias{plot.model.3pl}
\alias{print.model.3pl}
\title{3-Parameter-Logistic Model}
\usage{
model_3pl(people = NULL, items = NULL, responses = NULL, theta = NULL,
  a = NULL, b = NULL, c = NULL)

\method{print}{model.3pl}(x, ...)

\method{plot}{model.3pl}(x, ...)
}
\arguments{
\item{people}{people parameters (data.frame)}

\item{items}{item parameters (data.frame)}

\item{responses}{dichotomous responses (data.frame or matrix)}

\item{theta}{the ability parameters (vector)}

\item{a}{the discrimination parameters (vector)}

\item{b}{the difficulty parameters (vector)}

\item{c}{the pseudo-guessing parameters (vector)}

\item{x}{a \code{model.3pl} object}

\item{...}{additional arguments}
}
\description{
Create a 3-parameter-logistic (3PL) model object
}
\details{
A 3pl model contains \code{people} (people parameters), \code{items} 
(item parameters), \code{responses} (responses data), and functions to 
compute \code{P} (probability), \code{I} (information), and \code{L} 
(likelihood). \cr
Arguments are allowed to be \code{NULL}. The \code{people} argument needs 
to have a column named \code{theta}. The \code{items} argument needs to 
have columns named \code{a}, \code{b}, and \code{c}. The \code{responses} 
argument needs to be a data frame or matrix whose dimensionality matches 
with \code{people} and \code{items}.

In \code{plot.model.3pl}, use the \code{stats} argument to control what IRT statistics to draw.
Use \code{total} argument to control whether to aggregate results over items or people.
}
\examples{
# create a 3pl model using given parameters
theta <- c(-1, 0, 1)
a <- c(.5882, 1)
b <- c(-1, 1)
c <- c(0, .2)
u <- matrix(c(1, 0, 1, 0, 1, 0), nrow=3)
people <- data.frame(theta=theta)
items <- data.frame(a=a, b=b, c=c)
model_3pl(people=people, items=items, responses=u) 
model_3pl(people=people, items=items) 
model_3pl(theta=theta, a=a, b=b, c=c) 
model_3pl(people=people, a=a, b=b, c=c) 
model_3pl(theta=theta, items=items) 
# compute P(robability), I(nformation), L(ikelihood)
x <- model_3pl(people=people, items=items, responses=u)
x$P()
x$I()
x$L()
model_3pl()$P(x)
model_3pl()$I(x)
model_3pl()$L(x)
# create a 3pl model using generated data
x <- model_3pl()$gendata(10, 5)
x$P(x)
x$I(x)
x$L(x)
# draw test/item characteristic curve
x <- model_3pl()$gendata(20, 5)
plot(x, stats="prob")
plot(x, stats="prob", total=FALSE)
# draw test/iten information function
plot(x, stats="info")
plot(x, stats="info", total=FALSE)
# draw loglikelihood
plot(x, stats="loglik")
plot(x, stats="loglik", total=FALSE, theta=seq(-5, 5, .1))
}

