% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{xyloplot}
\alias{xyloplot}
\alias{xyloplot.list}
\alias{xyloplot.factor}
\alias{xyloplot.logical}
\alias{xyloplot.character}
\alias{xyloplot.numeric}
\title{Create a xyloplot}
\usage{
xyloplot(x, ...)

\method{xyloplot}{list}(x, breaks = NULL, space = 0.1, pivot = if
  (!is.null(names(x))) factor(names(x), levels = names(x)) else
  seq_along(x), pivot_labels = if (is.factor(pivot)) levels(pivot) else
  NULL, just = 0.5, freq = FALSE, ...)

\method{xyloplot}{factor}(x, ...)

\method{xyloplot}{logical}(x, ...)

\method{xyloplot}{character}(x, ...)

\method{xyloplot}{numeric}(x, ...)
}
\arguments{
\item{x}{Vector or list of vectors to use for creating xyloplots.}

\item{...}{Additional arguments passed to \code{\link{xyloplot.list}}, or other graphical parameters (e.g. \code{"col"}, \code{"lwd"}, ..., etc.) for \code{xyloplot.list} which are recycled along the xylophones and then used by functions for rendering the individual rectangles (e.g. \code{rect}).}

\item{breaks}{A single positive integer value giving the number of breakpoints to use for an evenly spaced partition of the values in \code{x}, a numeric vector explicitly giving the the breakpoints, or \code{NULL} to use the default partition.}

\item{space}{The proportion of the total distance on the pivots axis allocated to each 'xylophone' which should be empty or \code{NULL}, in which case the pivot axis coordinates for the xyloplot rectangles for each pivot are transformed to [0, 1].}

\item{pivot}{Vector the same length as \code{x} used to determine which pivot to place the xylophone representing corresponding distributions of \code{x} onto (duplicated values go on the same pivots).}

\item{pivot_labels}{Character vector giving names for each pivot or \code{NULL}.}

\item{just}{Vector whose elements should take values in \code{0, 0.5, 1} which determines whether to centre-align the xylophones (\code{0.5}, default), left align them (\code{0}) or right align them (\code{1}).}

\item{freq}{Logical value. If \code{TRUE}, the frequencies/counts of data points falling in each interval are represented. If \code{FALSE} (default), the frequency density of data points in each interval are represented.}
}
\value{
Returns an object of class \code{"xyloplot"} containing the specification of graphical elements required to create a corresponding plot, including the coordinates of the corners of rectangles (in terms of the location on the value value axis and the pivot axis across which the xyloplots are spread) and the positions of the breakpoints used to partition the range of values.
}
\description{
Plots xylophones (centre-aligned histograms) for the input vector(s), provided either as a single vector or list of vectors. Numeric vectors and factors are admissible (character vectors are transformed to factors). If numeric vectors are provided, \code{cut} will be used to aggregate values, whereas if character vectors or factors are provided, each 'level' will have it's own `key' on the `xylophone'. Note that if factors are used, all factors in `x` must have identical levels.
}
\seealso{
\code{\link{plot.xyloplot}}
}
