% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classified.R
\name{as.integer.classified}
\alias{as.integer.classified}
\title{Coerce Classified to Integer}
\usage{
\method{as.integer}{classified}(
  x,
  offset = 0L,
  ...,
  persistence = getOption("yamlet_persistence", TRUE)
)
}
\arguments{
\item{x}{classified, see \code{\link{classified}}}

\item{offset}{an integer value to add to intermediate result}

\item{...}{passed to \code{\link{desolve}}}

\item{persistence}{whether to return 'dvec' (is.integer(): TRUE) or just integer.}
}
\value{
integer (possibly of class dvec)
}
\description{
Coerces classified to integer.
Result is like \code{as.integer(as.numeric(x)) + offset}
but has a guide attribute: a list of integers 
whose names are the original levels of x.
If you need a simple integer, consider coercing first to numeric.
}
\examples{
library(magrittr)

# create factor with codelist attribute
classified(c('knife','fork','spoon'))

# give back a simple numeric
classified(c('knife','fork','spoon')) \%>\% as.numeric

# intentionally preserve levels as 'guide' attribute
classified(c('knife','fork','spoon')) \%>\% as.integer

# implement offset
classified(c('knife','fork','spoon')) \%>\% as.integer(-1)

# globally defeat the 'persistence' paradigm
options(yamlet_persistence = FALSE)
c('knife','fork','spoon') \%>\% 
  classified \%>\%
  as.integer \%>\% 
  class # integer
  
# remove option to restore default persistence paradigm
options(yamlet_persistence = NULL)
c('knife','fork','spoon') \%>\% 
  classified \%>\%
  as.integer \%>\% 
  class # dvec
  
# locally defeat persistence paradigm
c('knife','fork','spoon') \%>\% 
  classified \%>\%
  as.integer(persistence = FALSE) \%>\% 
  class # integer
  

}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.default}()},
\code{\link{classified.dvec}()},
\code{\link{classified.factor}()},
\code{\link{classified}()},
\code{\link{desolve.classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}
}
\concept{classified}
