% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_title.R
\name{make_title.dvec}
\alias{make_title.dvec}
\title{Make Title for Decorated Vector}
\usage{
\method{make_title}{dvec}(x, ..., with_title = getOption("yamlet_with_title", TRUE))
}
\arguments{
\item{x}{dvec}

\item{...}{ignored arguments}

\item{with_title}{whether to drop title}
}
\value{
dvec
}
\description{
Makes title for decorated vectors.
If option \code{with_title} is TRUE
and x has a 'units' attribute,
it adds the title attribute. See also 
\code{\link{drop_title}} for coordinated use.
}
\examples{
library(magrittr)
1 \%>\% 
as_dvec(label = 'length', guide = 'mm') \%>\%
resolve
}
\seealso{
Other labels: 
\code{\link{alias.data.frame}()},
\code{\link{append_units.data.frame}()},
\code{\link{append_units.default}()},
\code{\link{append_units}()},
\code{\link{drop_title.decorated}()},
\code{\link{drop_title.default}()},
\code{\link{drop_title.dvec}()},
\code{\link{drop_title}()},
\code{\link{make_title.decorated}()},
\code{\link{make_title.default}()},
\code{\link{make_title}()},
\code{\link{sub_units}()}
}
\concept{labels}
\keyword{internal}
