% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve.classified}
\alias{resolve.classified}
\title{Resolve Classified}
\usage{
\method{resolve}{classified}(x, ...)
}
\arguments{
\item{x}{classified}

\item{...}{ignored}
}
\value{
classified
}
\description{
Resolves classified.
A non-operation since classified already has an explicit guide.
Useful to make resolve() idempotent for 'dvec'.
}
\examples{
library(magrittr)
x <- as_dvec(1:3, guide = list(a = 1, b = 2, c = 3))
x \%>\% str
x \%>\% classified \%>\% str
x \%>\% explicit_guide \%>\% classified \%>\% str
x \%>\% resolve \%>\% str
# idempotent:
x \%>\% resolve \%>\% resolve \%>\% str
}
\seealso{
Other resolve: 
\code{\link{desolve.classified}()},
\code{\link{desolve.decorated}()},
\code{\link{desolve.dvec}()},
\code{\link{desolve}()},
\code{\link{resolve.decorated}()},
\code{\link{resolve.dvec}()},
\code{\link{resolve}()}

Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as.data.frame.dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{as_dvec}()},
\code{\link{c.dvec}()},
\code{\link{classified.dvec}()},
\code{\link{desolve.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.dvec}()},
\code{\link{unclassified.dvec}()}
}
\concept{dvec}
\concept{resolve}
\keyword{internal}
