% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classified.R
\name{classified.dvec}
\alias{classified.dvec}
\title{Classify Decorated Vector}
\usage{
\method{classified}{dvec}(
  x,
  ...,
  exclude = NA,
  ordered = is.ordered(x),
  nmax = NA,
  token = character(0)
)
}
\arguments{
\item{x}{dvec}

\item{...}{un-named arguments ignored.  Named arguments passed to \code{\link{classified.default}} to modify behavior}

\item{exclude}{see \code{\link{factor}}}

\item{ordered}{see \code{\link{factor}}}

\item{nmax}{see \code{\link{factor}}}

\item{token}{informative label for messages}
}
\value{
classified
}
\description{
Coerces dvec to 'classified':
a factor with a codelist attribute.
Results may differ if explicit_guide()
is called first.
}
\examples{
library(magrittr)
x <- as_dvec(1:3)
attr(x, 'guide') <- list(a = 1, b = 2, c = 3)
x \%>\% str
x \%>\% classified \%>\% str
x \%>\% explicit_guide \%>\% classified \%>\% str
}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.default}()},
\code{\link{classified.factor}()},
\code{\link{classified_generic}},
\code{\link{desolve.classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}

Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as.data.frame.dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{as_dvec}()},
\code{\link{c.dvec}()},
\code{\link{desolve.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.dvec}()},
\code{\link{unclassified.dvec}()}
}
\concept{classified}
\concept{dvec}
\keyword{internal}
