% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{as.character.yamlet}
\alias{as.character.yamlet}
\title{Coerce Yamlet to Character}
\usage{
\method{as.character}{yamlet}(x, ...)
}
\arguments{
\item{x}{yamlet}

\item{...}{passed arguments}
}
\value{
character
}
\description{
Coerces yamlet to character.  See also \code{\link{as_yamlet.character}}.
}
\examples{

as.character(as_yamlet('ID: subject identifier'))
as.character(as_yamlet(c('id: subject','amt: dose')))
as.character(as_yamlet(c('id: subject\\namt: dose')))
foo <- as_yamlet(system.file(package = 'yamlet', 'extdata','yamlet.yaml'))
class(foo)
writeLines(as.character(foo))

file <- system.file(package = 'yamlet','extdata','yamlet.csv')
file
foo <- decorate(file, coerce = TRUE)
as.character(as_yamlet(foo))


}
\seealso{
Other as_yamlet: \code{\link{as_yamlet.data.frame}}
}
\concept{as_yamlet}
