% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R, R/singularity.R
\name{filter.decorated}
\alias{filter.decorated}
\title{Filter Decorated}
\usage{
\method{filter}{decorated}(
  .data,
  ...,
  .preserve = FALSE,
  .promote = getOption("yamlet_promote", TRUE)
)

\method{filter}{decorated}(
  .data,
  ...,
  .preserve = FALSE,
  .promote = getOption("yamlet_promote", TRUE)
)
}
\arguments{
\item{.data}{passed to \code{\link[dplyr]{filter}}}

\item{...}{passed to \code{\link[dplyr]{filter}}}

\item{.preserve}{passed to \code{\link[dplyr]{filter}}}

\item{.promote}{whether to auto-promote plural attributes}

\item{preserve}{see \code{\link[dplyr]{filter}}}
}
\value{
decorated
}
\description{
Preserves class when filtering decorated.

Filters a decorated data.frame.
After a filter operation, promote()
is called to see if ambiguous conditional
attributes can be improved.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- file \%>\% decorate

# Note that there are two elements each for value label and value guide.
x \%>\% decorations(event, value)

# Filtering promotes the relevant conditional attributes automatically.
x \%>\% filter(event == 'dose') \%>\% decorations(value)
x \%>\% filter(event == 'conc') \%>\% decorations(value)

}
\seealso{
Other dplyr: 
\code{\link{anti_join.decorated}()},
\code{\link{arrange.decorated}()},
\code{\link{as_decorated}()},
\code{\link{full_join.decorated}()},
\code{\link{group_by.decorated}()},
\code{\link{inner_join.decorated}()},
\code{\link{left_join.decorated}()},
\code{\link{mutate.decorated}()},
\code{\link{right_join.decorated}()},
\code{\link{select.decorated}()},
\code{\link{semi_join.decorated}()},
\code{\link{slice.decorated}()},
\code{\link{summarise.decorated}()},
\code{\link{summarize.decorated}()}

Other promote: 
\code{\link{[.decorated}()},
\code{\link{promote.default}()},
\code{\link{promote}()},
\code{\link{singularity}()}
}
\concept{dplyr}
\concept{promote}
\keyword{internal}
