% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate.R
\name{redecorate}
\alias{redecorate}
\title{Redecorate a List-like Object}
\usage{
redecorate(x, meta = NULL, ..., overwrite = TRUE)
}
\arguments{
\item{x}{object}

\item{meta}{file path for corresponding yamlet metadata, or a yamlet object}

\item{...}{passed arguments}

\item{overwrite}{passed to \code{\link{decorate}}}
}
\value{
a list-like object, typically data.frame
}
\description{
Redecorates a list-like object.
Equivalent to \code{decorate( ..., overwrite = TRUE)}.
If \code{meta} is not supplied, an attempt will be made
to redecorate with existing decorations, if any.
}
\examples{
library(dplyr)
library(magrittr)
library(csv)
library(haven)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(as.csv(file))
x \%>\% select(Subject) \%>\% decorations
x \%<>\% redecorate('Subject: Patient Identifier')
x \%>\% select(Subject) \%>\% decorations

# xpt may already have labels:

dm <- 'extdata/dm.xpt.gz' \%>\% 
  system.file(package = 'yamlet') \%>\% 
  gzfile \%>\% 
  read_xpt

dm \%>\% class  
dm \%>\% decorations(AGE, SEX, RACE)

# but technically not decorated, and poor persistence:
bind_rows(dm, dm) \%>\% decorations(AGE, SEX, RACE)

# self-redecorating helps:
dm \%<>\% redecorate
bind_rows(dm, dm) \%>\% decorations(AGE, SEX, RACE)
}
\seealso{
Other decorate: 
\code{\link{as_decorated}()},
\code{\link{as_decorated.default}()},
\code{\link{decorate}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{decorate.list}()},
\code{\link{decorate_groups}()},
\code{\link{decorate_groups.data.frame}()},
\code{\link{decorations}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations_groups}()},
\code{\link{decorations_groups.data.frame}()},
\code{\link{group_by_decorations}()},
\code{\link{group_by_decorations.data.frame}()}
}
\concept{decorate}
\keyword{internal}
