% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selected.R
\name{selected.default}
\alias{selected.default}
\title{Identify Selected Names by Default}
\usage{
\method{selected}{default}(x, ..., expand = TRUE)
}
\arguments{
\item{x}{object}

\item{...}{to \code{\link[dplyr]{select}}}

\item{expand}{if true, selecting nothing expands to selecting everything}
}
\value{
character: names in x
}
\description{
Evaluates un-named arguments in \code{...} using
\code{\link[dplyr]{select}} rules, returning
explicit names in x.  Returns all (non-empty) names
by default (if no dots supplied).
}
\examples{
library(magrittr)
list(a = 1, b = 1:10, c = letters) \%>\%
selected(b:c)

}
\seealso{
Other modify: 
\code{\link{modify}()},
\code{\link{modify.default}()},
\code{\link{named}()},
\code{\link{selected}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{scripted.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{modify}
\keyword{internal}
