% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read.arff}
\alias{read.arff}
\title{Read an ARFF file}
\usage{
read.arff(file, stringsAsFactors = FALSE)
}
\arguments{
\item{file}{Name of the file to read the data from}

\item{stringsAsFactors}{Logical: should string attributes be converted to
factors? (nominal attributes are always converted to factors)}
}
\value{
A \code{data.frame} with some attributes:
\itemize{
\item attributes: a named vector indicating the type of each variable
\item relation: the original \code{@relation} of the dataset
}

Use \code{attr.names()}, \code{attr.types()} and \code{relation()} to consult attribute
names, types and the name of the dataset, respectively.
}
\description{
Reads a dataset from an ARFF file, parsing each section and
converting the data section into a \code{data.frame}.
}
\examples{

library(yarr)
\donttest{
yeast <- read.arff("yeast.arff")
}
}
