% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epa.R
\name{vis_kernel}
\alias{vis_kernel}
\title{Visualise kernel weights}
\usage{
vis_kernel(data, x = NULL, hx = NULL, tau = NULL, ht = NULL, ...)
}
\arguments{
\item{data}{Bond data. If \code{x} and \code{hx} are not NULL, \code{data}
needs to include one time index column \code{qdate}. If \code{tau} and
\code{ht} are not NULL, \code{data} needs to include one column of time to
maturity in days \code{tupq}.}

\item{x}{Time grids at which the discount curve is evaluated. Should be
specified using the same class of object as the quotation date (\code{qdate})
column in \code{data}.}

\item{hx}{Numeric vector. Bandwidth parameters corresponding to each time
point \code{x}.}

\item{tau}{Numeric vector. Time-to-maturities in years where
discount function and yield curve will be estimated for each of time points \code{x}.
See \code{Details}.}

\item{ht}{Numeric vector. Bandwidth parameters corresponding to each value of
time-to-maturities \code{tau}. See \code{Details}.}

\item{...}{Specification of an additional covariate, taking the form of \code{var = list(grid, bandwidth)}, where \code{var} is the name of the covariate in
\code{data}, \code{grid} is the values at which the yield curve is estimated,
similar to \code{x}, and \code{bandwidth} is the bandwidth parameter corresponding to
each of the \code{grid} values, similar to \code{hx}.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
\code{vis_kernel()} visualises kernel weights assigned to the intervals
surrounding specific grid points using the Epanechnikov
kernel function and given bandwidths.
}
\details{
If \code{x} and \code{hx} are provided, the kernel weights assigned to the intervals
surrounding each of time points \code{x} will be plotted.

If \code{tau} and \code{ht} are provided, the kernel weights assigned to the intervals
surrounding each of time-to-maturities \code{tau} will be plotted.

If the grid and bandwidth of a covariate are provided in \code{...}, the
kernel weights of that covariate will be plotted.

The kernel weights can only be plotted in one dimension (time,
time-to-maturity, or covariate) at a time.
}
\examples{
bonds <- ycevo_data()
vis_kernel(bonds, x = lubridate::ymd("2023-06-01"), hx = 0.2)

}
\seealso{
\code{\link[=ycevo_data]{ycevo_data()}}, \code{\link[=ycevo]{ycevo()}}
}
