% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_yml.R
\name{use_yml}
\alias{use_yml}
\alias{use_rmarkdown}
\alias{use_index_rmd}
\title{Copy YAML code to your clipboard or write to a new R Markdown file}
\usage{
use_yml(.yml = last_yml())

use_rmarkdown(
  .yml = last_yml(),
  path,
  template = NULL,
  include_yaml = TRUE,
  include_body = TRUE,
  body = NULL,
  quiet = FALSE,
  open_doc = interactive(),
  overwrite = getOption("usethis.overwrite", FALSE)
)

use_index_rmd(
  .yml = last_yml(),
  path,
  template = NULL,
  include_yaml = TRUE,
  include_body = TRUE,
  body = NULL,
  quiet = FALSE,
  open_doc = interactive()
)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{path}{A file path to write R Markdown file to}

\item{template}{An existing R Markdown file to read YAML from}

\item{include_yaml}{Logical. Include the template YAML?}

\item{include_body}{Logical. Include the template body?}

\item{body}{A character vector to use in the body of the R Markdown file. If
no template is set, checks \code{getOption("ymlthis.rmd_body")} (see
\code{\link[=use_rmd_defaults]{use_rmd_defaults()}}) and otherwise uses \code{\link[=setup_chunk]{setup_chunk()}}.}

\item{quiet}{Logical. Whether to message about what is happening.}

\item{open_doc}{Logical. Open the document after it's created? By default,
this is \code{TRUE} if it is an interactive session and \code{FALSE} if not. Also
checks that RStudio is available.}

\item{overwrite}{Logical. If \code{TRUE}, overwrites the file without asking for
permission. If \code{FALSE}, asks interactively if the user wishes to do so.
Checks the user's \code{usethis.overwrite} option if set and is otherwise
\code{FALSE} by default.}
}
\value{
\code{use_yml()} invisibly returns the input \code{yml} object
}
\description{
\code{use_yml()} takes a \code{yml} object and puts the resulting YAML on your
clipboard to paste into an R Markdown or YAML file. \code{use_rmarkdown()} takes
the \code{yml} object and writes it to a new R Markdown file. You can add text to
include in the body of the file. If it's not specified, \code{use_rmarkdown()}
will use \code{\link[=setup_chunk]{setup_chunk()}} by default. You can also set a default for \code{body}
using \code{options(ymlthis.rmd_body = "{your text}")}; see \code{\link[=use_rmd_defaults]{use_rmd_defaults()}}.
Together with specifying default YAML (see \code{\link[=use_yml_defaults]{use_yml_defaults()}}),
\code{use_rmarkdown()} also serves as an ad-hoc way to make R Markdown templates.
You may also supply \code{use_rmarkdown()} with an existing R Markdown file from
which to read the YAML header; the YAML header from the template is then
combined with \code{.yml}, if it's supplied, and written to a new file.
\code{use_index_rmd()} is a wrapper around \code{use_rmarkdown()} that specifically
writes to a file called \code{index.Rmd}. By default, \code{use_yml()} and
\code{use_rmarkdown()} use the most recently printed YAML via \code{\link[=last_yml]{last_yml()}}.
}
\seealso{
\code{\link[=code_chunk]{code_chunk()}} \code{\link[=setup_chunk]{setup_chunk()}}

Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}
}
\concept{yml}
