% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forms.R
\name{formGroup}
\alias{formGroup}
\alias{formRow}
\title{Input labels, help text, and formatting to inputs}
\usage{
formGroup(label, input, ..., help = NULL, width = NULL)

formRow(...)
}
\arguments{
\item{label}{A character string specifying a label for the input or \code{NULL}
in which case a label is not added.}

\item{input}{A tag element specifying the input to label.}

\item{...}{For \strong{formGroup}, additional named arguments passed as HTML
attributes to the parent element.

For \strong{formRow}, any number of \code{formGroup}s or additional named arguments
passed as HTML attributes to the parent element.}

\item{help}{A character string specifying help text for the input, defaults
to \code{NULL}, in which case help text is not added.}

\item{width}{A \link{responsive} argument. One of \code{1:12} or "auto" specifying a
column width for the form group, defaults to \code{NULL}.}
}
\description{
Form groups are a way of labelling an input. Form rows are similar to
\code{\link[=columns]{columns()}}s, but include additional styles intended for forms. The
flexibility provided by form rows and groups means you can confidently
develop shiny applications for devices and screens of varying sizes.
}
\examples{

### Grid layout forms

# Use responsive arguments to adjust form layouts based on viewport size.
# Be sure to adjust the size of your browser window between large and small.

card(
  formRow(
    formGroup(
      width = c(md = 6),  # <-
      label = "Username",
      textInput(
        id = "user"
      )
    ),
    formGroup(
      width = c(md = 6),  # <-
      label = "Password",
      textInput(
        type = "password",
        id = "pass"
      )
    )
  ),
  formGroup(
    label = "Username",
    groupTextInput(
      id = "username",
      left = "@"
    )
  ),
  buttonInput(
    id = "go",
    label = "Go!"
  ) \%>\%
    background("blue")
) \%>\%
  margin(3) \%>\%
  background("grey")

}
\concept{layout}
