% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{ypr_report}
\alias{ypr_report}
\title{Report}
\usage{
ypr_report(
  population,
  title = "Population Report",
  description = "",
  date = Sys.Date(),
  file = "report",
  view = FALSE,
  ask = TRUE
)
}
\arguments{
\item{population}{An object of class \code{\link[=ypr_population]{ypr_population()}}.}

\item{title}{A string of the report title.}

\item{description}{A string describing the population.}

\item{date}{A date of the report date.}

\item{file}{A string of the path to the file (without the extension).}

\item{view}{A flag specifying whether to view the report (after rendering it to html).}

\item{ask}{A flag specifying whether to ask before overwriting or creating a file.}
}
\value{
An invisible character vector of the contents of the file.
}
\description{
Creates an Rmd file that can be used to generate a report.
}
\examples{
ypr_report(ypr_population(), file = tempfile(), ask = FALSE)
}
