% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcTest.R
\name{lcTest}
\alias{lcTest}
\title{Log-contrast homogeneity test}
\usage{
lcTest(X, label = 0, groups = NULL, lc = NULL, method = c("parametric",
  "nonparametric"), b = 1000)
}
\arguments{
\item{X}{Compositional data set (\code{\link{matrix}} or \code{\link{data.frame}} class).}

\item{label}{Unique label (\code{\link{numeric}} or \code{\link{character}}) used to denote zero or unobserved data in \code{X} (\code{label = 0}, default).}

\item{groups}{Grouping factor in fully observed zero-free data sets (\code{groups = NULL}, default).}

\item{lc}{User-defined log-contrast (see details below).}

\item{method}{Approach used for mean and variance homogeneity testing (\code{method = "parametric"}, default).}

\item{b}{Number of bootstrap resamples used by permutation test (\code{b = 1000}, default).}
}
\value{
Test p-values for log-contrast means and variances.
}
\description{
This function tests for homogeneity across groups of means and variances of
user-defined log-contrasts. Groups can be defined by either zero/unobserved data patterns or by a grouping
factor in fully observed zero-free data sets.
}
\details{
Homogeneity of log-contrast means and variances across groups is tested using either parametric or non-parametric tests. When
\code{method = "parametric"}, ordinary analysis of variance and Bartlett's tests are used. Alternatively,
Kruskal-Wallis and Fligner-Killen tests are used instead when \code{method = "nonparametric"}. The results of a permutation test of homogeneity of variation
arrays based on total weighted squared relative errors are also provided (see \code{\link{zVarArrayTest}} for more details).
The log-contrast is specified by the \code{lc} argument using a vector of codes 1, -1 and 0 for components
in the numerator, denominator and omitted respectively.
}
\references{
Palarea-Albaladejo J. and Martin-Fernandez JA. zCompositions -- R package for multivariate imputation of
left-censored data under a compositional approach. Chemometrics and Intelligence Laboratory Systems 2015; 143: 85-96.
}

\examples{
data(Water)
zPatterns(Water, label = 0)

# Test of homogeneity in log-contrast Potassium/Arsenic*Calcium
lcTest(Water, label = 0, lc = c(1,-1,-1,0))
}
\seealso{
\code{\link{zPatterns}}, \code{\link{zVarArray}}, \code{\link{zVarArrayError}}
}

