% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{z.stats}
\alias{z.stats}
\title{Summary statistics table for a correlation}
\usage{
z.stats(correlation = "DAK", pprRange = "lp", interval = "coarse")
}
\arguments{
\item{correlation}{identifier. Can be "HY", "DAK", "DPR" "N10", "SH"}

\item{pprRange}{low (lp) or high (hp) chart area of the Standing-Katz chart}

\item{interval}{quality of the Ppr scale. Coarse: every 1.0; Fine: every 0.5}
}
\description{
Get error summary statistics for any given compressibility correlation.
A quick way to show an error summary between any of the indicated correlations and
the Standing-Katz chart.

    MSE:   Mean Squared Error
    RMSE:  Root Mean Squared Error
    RSS:   Residual sum of Squares
    RMSLE: Root Mean Squared Logarithmic Error. Penalizes understimation.
    MAPE:  Mean Absolute Percentage Error = AARE
    MPE:   Mean Percentage error = ARE
    MAE:   Mean Absolute Error
}
\examples{
\dontrun{
# error statistics for the Dranchuk-AbouKassem correlation
z.stats("DAK")
}
}
