% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassie.R
\name{format.lassie}
\alias{format.lassie}
\title{Format a lassie object}
\usage{
\method{format}{lassie}(x, what_x, range, what_range, what_sort, decreasing,
  na.rm, ...)
}
\arguments{
\item{x}{\code{\link[zebu]{lassie}} S3 object.}

\item{what_x}{vector specifying values to be returned:
\itemize{
\item 'local': local association measure values (default).
\item 'obs': observed probabilities.
\item 'exp': expected probabilities.
\item 'local_p': p-value of local association (after running \code{\link[zebu]{permtest}}).
}}

\item{range}{range of values to be retained (vector of two numeric values).}

\item{what_range}{character specifying what value \code{range} refers to
(same options as \code{what_x}).
By default, takes the first value in \code{what_x}.}

\item{what_sort}{character specifying according to which values should \code{x} be sorted
(same options as \code{what_x}).
By default, takes the first value in \code{what_x}.}

\item{decreasing}{logical value specifying sort order.}

\item{na.rm}{logical value indicating whether NA values should be stripped.}

\item{...}{other arguments passed on to methods. Not currently used.}
}
\description{
Formats a \code{\link[zebu]{lassie}} object for printing to console
(see \code{\link[zebu]{print.lassie}}) and for writing to a file
(see \code{\link[zebu]{write.lassie}}). Melts probability or local association
measure arrays into a data.frame.
}
\seealso{
\code{\link[zebu]{lassie}}
}
