% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenpath.R
\name{groupData}
\alias{groupData}
\title{Splitting a Matrix into a List of Matrices}
\usage{
groupData(x, indices, byrow = FALSE)
}
\arguments{
\item{x}{A \code{\link{matrix}} (or an object
convertible to such via \code{\link{as.matrix}()}).}

\item{indices}{list of vectors of indices according to
which \code{x} is grouped; each vector of indices define a group.}

\item{byrow}{\code{\link{logical}} indicating whether the grouping is
done by row (\code{byrow = TRUE}) 
or by column (\code{byrow = FALSE}, the default).}
}
\value{
A \code{\link{list}} of matrices (one per group). 
        Such a list, grouped by columns, is then typically passed on to \code{\link{zenplot}()}.
}
\description{
Takes a matrix \code{x} and groups its rows (or columns) 
as specified by \code{indices}.  Returns a list of matrices, one for each group.
}
\examples{
## get a matrix
x <- matrix(1:15, ncol = 3)
colGroups <- list(c(1,2), list(2:3))
rowGroups <- list(c(1,4), list(2:3))
groupData(x, indices = colGroups)
groupData(x, indices = rowGroups, byrow = TRUE)


}
\seealso{
\code{\link{zenplot}()} which provides the zenplot.

Other tools related to constructing zenpaths: \code{\link{connect_pairs}},
  \code{\link{extract_pairs}}, \code{\link{graph_pairs}},
  \code{\link{indexData}}, \code{\link{zenpath}}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{tools related to constructing zenpaths}
