# zenplots

[![Build Status](https://travis-ci.org/great-northern-diver/zenplots.svg?branch=master)](https://travis-ci.org/great-northern-diver/zenplots) [![CRAN\_Status\_Badge](https://www.r-pkg.org/badges/version/zenplots)](https://cran.r-project.org/package=zenplots)

Plotting paths to data enlightenment <img src="man/figures/logo.png" align="right" width="120" />

* Online documentation is available [here](https://great-northern-diver.github.io/zenplots/)

The package zenplots (**z**igzag
**e**xpanded **n**avigation **plots**) displays high-dimensional data by laying out alternating one- and two-dimensional plots in a zigzag-like pattern where adjacent axes share the same variate. 

Zenplots are especially useful when
subsets of pairs can be identified as of particular interest by some measure, or as not meaningfully comparable, or when pairs of variates can be ordered in terms of potential interest to view, or the number of pairs is too large for more traditional layouts such as a scatterplot matrix. They also allow an essentially arbitrary layout of plots. 

High dimensional space can be explored in a zenplot (`zenplot()`) by navigating through lower dimensional subspaces along a zenpath (`zenpath()`) which orders the dimensions (i.e. variates) visited according to some measure of interestingness; see [Hofert and Oldford (2018))](https://www.sciencedirect.com/science/article/pii/S245230621730031X) for an application to S&P 500 constituent data or [Hofert et al (2019)](https://www.sciencedirect.com/science/article/pii/S0047259X1830023X) for application to visualizing dependence between two sets of variates.  See [Hofert and Oldford (2020)](https://doi.org/10.18637/jss.v095.i04) in [Journal of Statistical Software](https://www.jstatsoft.org/) for algorithms.

The `R` package zenplots provides compact displays for high-dimensional data via the
notion of zenplots, grouping of variates, and customizable displays of zigzag layouts. It accommodates different graphical systems including the base `graphics` package, the `grid` package (and hence packages like `ggplot2`), and the interactive graphical package `loon`. 

`zenplots` handles groups of variates, partial and fully missing data, and more. 

One important feature is that `zenplot()` and its auxiliary functions in zenplots distinguish layout from plotting which allows one to freely choose and create one- and two-dimensional plot functions; predefined functions are exported for all graphical systems.

Try it. 

Become one with your data!
