% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dloon.R
\name{label_2d_loon}
\alias{label_2d_loon}
\title{Label plot in 2d using the interactive loon package}
\usage{
label_2d_loon(
  zargs,
  loc = NULL,
  label = NULL,
  rot = 0,
  size = 8,
  box = FALSE,
  color = NULL,
  linkingGroup = NULL,
  showLabels = FALSE,
  showScales = FALSE,
  showGuides = FALSE,
  baseplot = NULL,
  parent = NULL,
  group... = NULL,
  ...
)
}
\arguments{
\item{zargs}{The argument list as passed from \code{\link{zenplot}()}}

\item{loc}{The location of the label}

\item{label}{The label to be used}

\item{rot}{The rotation of the label}

\item{size}{The font size}

\item{box}{A \code{\link{logical}} indicating whether the label is to be enclosed
in a box.}

\item{color}{Color of the label (and of box when \code{box = TRUE}).}

\item{linkingGroup}{The initial linking group}

\item{showLabels}{Logical determining whether axis labels are displayed}

\item{showScales}{Logical determining whether scales are displayed}

\item{showGuides}{Logical determining whether the background guidelines are displayed}

\item{baseplot}{If non-null the base plot on which the plot should be layered}

\item{parent}{The tk parent for this loon plot widget}

\item{group...}{A list of arguments passed to group_2d_loon (or NULL)}

\item{...}{Additional parameters passed to loon::l_layer_text(...)}
}
\value{
The base loon::l_plot with the added text layer
}
\description{
Label plot in 2d using the interactive loon package
}
\seealso{
Other default 2d plot functions using the interactive loon package: 
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_loon}()},
\code{\link{group_2d_loon}()},
\code{\link{points_2d_loon}()},
\code{\link{rect_2d_loon}()}

Other default 2d plot functions: 
\code{\link{arrow_2d_graphics}()},
\code{\link{arrow_2d_grid}()},
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_graphics}()},
\code{\link{axes_2d_grid}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_graphics}()},
\code{\link{density_2d_grid}()},
\code{\link{density_2d_loon}()},
\code{\link{extract_2d}()},
\code{\link{group_2d_graphics}()},
\code{\link{group_2d_grid}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_graphics}()},
\code{\link{label_2d_grid}()},
\code{\link{points_2d_graphics}()},
\code{\link{points_2d_grid}()},
\code{\link{points_2d_loon}()},
\code{\link{qq_2d_graphics}()},
\code{\link{qq_2d_grid}()},
\code{\link{rect_2d_graphics}()},
\code{\link{rect_2d_grid}()},
\code{\link{rect_2d_loon}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 2d plot functions}
\concept{default 2d plot functions using the interactive loon package}
