% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zerotradeflow.R
\docType{data}
\name{comtrade}
\alias{comtrade}
\title{A sample of the UN Comtrade Database.}
\format{
A dataframe object.
}
\source{
Repository UN Comtrade.
}
\usage{
comtrade
}
\value{
a dataframe object contains the five variables passed as parameters
to the get_zerotradeflow() function (year, exporter, importer, item, trade)
including the bilateral trade flow equal to zero.
}
\description{
A sample of the UN Comtrade Database prepared by the United
Nations Department of Statistics with official international trade
information.
}
\details{
In the following example the original base (comtrade.rda) has only 229,585
information on positive bilateral trade flow (greater than zero). However,
after expanding this base to also present the bilateral trade flow equal to
zero, the new base will have 1,255,892 observations (both positive and zero
flow). Note that the final size of the base will depend on the number of
years, the number of exporting and importing countries and the items present
in the base. Since the distinct number of exporting and importing countries
has an important determining factor in the expansion of the base (see the
examples with the distinct.rda and same.rda bases).

A dataset consisting of two years, 24 exporting countries, 24
importing countries, 1,241 Harmonized System codes and the value of exports
in dollars. The data includes the following fields:

* ano - Numeric. Year in which exports were carried out.
* ido - String. ISO code corresponding to the exporting country.
* idd - String. ISO code corresponding to the importing country.
* HS4 - Numeric. HS4 code corresponding to the merchandise sold.
* comercio - Numeric. Dollar value of exports.
}
\examples{


\donttest{

zeroflow <- get_zerotradeflow(comtrade, ano, ido, idd, HS4, comercio)

}


}
\keyword{comtrade}
\keyword{international.}
\keyword{sample}
\keyword{trade}
