% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Zeta.scale.min.dist}
\alias{Zeta.scale.min.dist}
\title{Zeta diversity scaling with sample grain dependency based on the minimum distance between sites}
\usage{
Zeta.scale.min.dist(xy, data.spec, m, order = 1, reorder = 100,
  shuffle = TRUE, sam = 1000, method = "mean", rescale = FALSE,
  normalize = FALSE, plot = TRUE, sd = TRUE,
  distance.type = "Euclidean", dist.custom = NULL, zeta.type = "exact")
}
\arguments{
\item{xy}{Site-by-coordinate data frame, with sites as rows and coordinates as columns.}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{m}{Vector of mapping grains: \code{m[i]} sites are grouped together to generate data at a coarser grain.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{reorder}{Number of times the sites are rearranged and grouped together for the computation of zeta (see Details).}

\item{shuffle}{Boolean value (TRUE or FALSE) indicating if the order of the sites must be randomised, which can have an impact on the outputs if some distances are equal.}

\item{sam}{Number of samples for which the zeta diversity is computed.}

\item{method}{Name of a function (as a string) indicating how to combine the coordinates. It can be a basic R-function such as "\code{mean}" or "\code{max}", but also a custom function.}

\item{rescale}{Boolean value (TRUE or FALSE) indicating if the zeta values should be divided by \eqn{\zeta_1}, to get a range of values between 0 and 1. Has no effect if \code{normalize} = \code{TRUE}.}

\item{normalize}{Boolean value (TRUE or FALSE) indicating if the zeta values for each sample should be divided by the total number of species for this specific sample.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}

\item{sd}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be plotted for each grain.}

\item{distance.type}{Method to compute distance. Default is "\code{Euclidean}", for Euclidean distance. The other options are (i) "\code{ortho}" for orthodromic distance, if xy correspond to longitudes and latitudes (orthodromic distance is computed using the \code{gdist} function from package \code{Imap}); and (ii) "\code{custom}", in which case the user must provide a distance matrix for \code{dist.custom}.}

\item{dist.custom}{Distance matrix provided by the user when \code{distance.type} = \code{"custom"}.}

\item{zeta.type}{The function that must be used for the computation of zeta diversity. Default is "\code{exact}" for calling \code{Zeta.order.ex}. Use "\code{monte carlo}" for calling \code{Zeta.order.mc}.}
}
\value{
\code{zeta.scale.min.dist} returns a list containing the following components:

\item{order}{The order of zeta.}

\item{m}{The vector of mapping grains: m[i] sites are grouped together to generate data at a coarser grain.}

\item{values}{A matrix containing the zeta diversity values over the '\code{reorder}' computations, for each grain.}

\item{sd}{A matrix containing the standard deviation of zeta diversity over the '\code{reorder}' computations, for each grain.}
}
\description{
Computes zeta diversity scaling with sample grain for a specific order (number of assemblages or sites), increasing grain by sequentially adding sites based on the minimum distance between them.
}
\details{
The nearest neighbouring sites (plots, quadrates, or areas of varying shapes) are grouped as spatial clusters of 2, 3, 4, etc. sites, based on the minimum distance between them. Since the procedure is based on the relative distance between sites, the site order can have an impact on the output. The procedure is therefore performed 'reorder' times, for which sites are randomly reordered each time, and the mean zeta is computed. This function is suitable for both regularly and irregularly spaced sites, contiguous or non contiguous (\emph{sensu} Scheiner et al., 2011). For regularly spaced sites, the use of \code{\link{Zeta.scale.regular}} is recommended.
}
\examples{
utils::data(Marion.species)
xy.marion <- Marion.species[,1:2]
data.spec.marion <- Marion.species[,3:33]

dev.new()
zeta.scale.irreg.species <- Zeta.scale.min.dist(xy.marion, data.spec.marion, m = 1:3, 
    order = 3, reorder = 3, sam = 50, normalize = TRUE)

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

Scheiner S.M., Chiarucci A., Fox G.A., Helmus M.R., McGlinn D.J. & Willig M.R. (2011). The underpinnings of the relationship of species richness with space and time. \emph{Ecological Monographs}, 81, 195-213.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}},

\code{\link{Zeta.scale.regular}}, \code{\link{rescale.regular}}
}

