% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Return.ispline}
\alias{Return.ispline}
\title{Computing splines coordinates from I-spline-based multi-site generalised dissimilarity modelling}
\usage{
Return.ispline(msgdm, data.env, distance = FALSE, biotic = 0)
}
\arguments{
\item{msgdm}{Output of function \code{Zeta.msgdm} computed with \code{reg.type = ispline}.}

\item{data.env}{Site-by-variable data frame used for the computation of \code{msgdm}, with sites as rows and environmental variables as columns.}

\item{distance}{Boolean, indicates is distance was used in the computation of \code{msgdm}.}

\item{biotic}{Integer, indicates the number of other groups of taxa for which zeta diversity was computed and used in the computation of \code{msgdm}.}
}
\value{
\code{Return.ispline} returns a list containing the following components used to plot the I-splines:

\item{env}{A data frame containing the rescaled environmental (numeric and factor), distance and biotic x-values.}

\item{Ispline}{A data frame containing the I-spline values corresponding to the rescaled environmental (numeric and factor), distance and biotic x-values.}
}
\description{
Stores the coordinates of the I-splines resulting from \code{Zeta.msgdm} for plotting.
}
\details{
\code{Return.ispline} allows to store the same number of coordinates for all I-splines, to average replicates and obtain confidence intervals.
}
\examples{

utils::data(Marion.species)
xy.marion <- Marion.species[1:2]
data.spec.marion <- Marion.species[3:33]

utils::data(Marion.env)
data.env.marion <- Marion.env[3]

zeta.ispline <- Zeta.msgdm(data.spec.marion, data.env.marion, xy.marion, sam = 100,
    order = 3, normalize = "Jaccard", reg.type = "ispline")
zeta.ispline
zeta.ispline.r <- Return.ispline(zeta.ispline, data.env.marion, distance = TRUE)
zeta.ispline.r

dev.new()
Plot.ispline(isplines = zeta.ispline.r, distance = TRUE)

dev.new()
Plot.ispline(msgdm = zeta.ispline, data.env = data.env.marion, distance = TRUE)

}
\seealso{
\code{\link{Zeta.msgdm}}, \code{\link{Ispline}}
}
