% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_zipfpssFit.R
\name{zi_zipfpssFit}
\alias{zi_zipfpssFit}
\alias{residuals.zi_zipfpssR}
\alias{fitted.zi_zipfpssR}
\alias{coef.zi_zipfpssR}
\alias{plot.zi_zipfpssR}
\alias{print.zi_zipfpssR}
\alias{summary.zi_zipfpssR}
\alias{logLik.zi_zipfpssR}
\alias{AIC.zi_zipfpssR}
\alias{BIC.zi_zipfpssR}
\title{Zero Inflated Zipf-PSS parameters estimation.}
\usage{
zi_zipfpssFit(data, init_alpha = 1.5, init_lambda = 1.5,
  init_w = 0.1, level = 0.95, ...)

\method{residuals}{zi_zipfpssR}(object, ...)

\method{fitted}{zi_zipfpssR}(object, ...)

\method{coef}{zi_zipfpssR}(object, ...)

\method{plot}{zi_zipfpssR}(x, ...)

\method{print}{zi_zipfpssR}(x, ...)

\method{summary}{zi_zipfpssR}(object, ...)

\method{logLik}{zi_zipfpssR}(object, ...)

\method{AIC}{zi_zipfpssR}(object, ...)

\method{BIC}{zi_zipfpssR}(object, ...)
}
\arguments{
\item{data}{Matrix of count data in form of table of frequencies.}

\item{init_alpha}{Initial value of \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{init_lambda}{Initial value of \eqn{\lambda} parameter (\eqn{\lambda > 0}).}

\item{init_w}{Initial value of \eqn{w} parameter (\eqn{0 < w < 1}).}

\item{level}{Confidence level used to calculate the confidence intervals (default 0.95).}

\item{...}{Further arguments to the generic functions. The extra arguments are passing
to the \emph{\link{optim}} function.}

\item{object}{An object from class "zpssR" (output of \emph{zipfpssFit} function).}

\item{x}{An object from class "zpssR" (output of \emph{zipfpssFit} function).}
}
\description{
For a given sample of strictly positive integer numbers,  usually of the type of ranking data or
frequencies of frequencies data, estimates the parameters of the zero inflated Zipf-PSS distribution by means of
the maximum likelihood method. The input data should be provided as a frequency matrix.
}
\details{
The argument \code{data} is a two column matrix with the first column containing the observations and
the second column containing their frequencies.
}
\examples{
data <- rzipfpss(100, 2.5, 1.3)
data <- as.data.frame(table(data))
data[,1] <- as.numeric(as.character(data[,1]))
data[,2] <- as.numeric(as.character(data[,2]))
obj <- zipfpssFit(data, init_alpha = 1.5, init_lambda = 1.5)
}
\references{
{
Panjer, H. H. (1981). Recursive evaluation of a family of compound
distributions. ASTIN Bulletin: The Journal of the IAA, 12(1), 22-26.

Sundt, B., & Jewell, W. S. (1981). Further results on recursive evaluation of
compound distributions. ASTIN Bulletin: The Journal of the IAA, 12(1), 27-39.
 }
}
\seealso{
\code{\link{getInitialValues}}.
}
