% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmmsim.R
\name{hsmmsim}
\alias{hsmmsim}
\title{Simulate a hidden semi-Markov series and its corresponding states
according to the specified parameters}
\usage{
hsmmsim(n, M, prior, dt_dist = "nonparametric", dt_parm, tpm_parm, emit_parm,
  zeroprop)
}
\arguments{
\item{n}{length of the simulated series}

\item{M}{number of hidden states}

\item{prior}{a vector of prior probability for each state}

\item{dt_dist}{dwell time distribution, which should be "log" or
"shiftpoisson" or "nonparametric". Default to "nonparametric".}

\item{dt_parm}{a vector of dwell time distribution parameters for each state. If 
dt_dist is "log", then dt_parm is vector of p's; if dt_dist is "shiftpoisson", then
dt_parm is vector of theta's; if dt_dist is "nonparametric", then dt_parm is
a matrix whose i,j th element is the probability of staying in state i for duration j.}

\item{tpm_parm}{transition probability matrix, whose diagonal should be zero's.}

\item{emit_parm}{a vector containing means for each poisson distribution}

\item{zeroprop}{a vector containing structural zero proportions in each state}
}
\value{
simulated series and corresponding states
}
\description{
Simulate a hidden semi-Markov series and its corresponding states
according to the specified parameters
}
\examples{
prior_init <- c(0.5,0.2,0.3)
dt_init <- c(0.8,0.5,0.2)
emit_init <- c(10,50,100)
zeroprop <- c(0.6,0.3,0.1)
omega <- matrix(c(0,0.3,0.7,0.4,0,0.6,0.5,0.5,0),3,3,byrow=TRUE)
sim1 <- hsmmsim(n=1000,M=3,prior=prior_init,dt_dist="log",
         dt_parm=dt_init, tpm_parm=omega,
         emit_parm=emit_init,zeroprop=zeroprop)
str(sim1)

prior_init <- c(0.5,0.5)
dt_init <- c(10,5)
emit_init <- c(10,30)
zeroprop <- c(0.5,0)
omega <- matrix(c(0,1,1,0),2,2,byrow=TRUE)
sim2 <- hsmmsim(n=1000,M=2,prior=prior_init,dt_dist="shiftpoisson",
         dt_parm=dt_init, tpm_parm=omega,
         emit_parm=emit_init,zeroprop=zeroprop)
str(sim2)
hist(sim2$series,main="Histogram of observed values",xlab="observed values")

}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
