% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeq.R
\name{zeq}
\alias{zeq}
\title{Generate sequence in a safe way}
\usage{
zeq(from, to)
}
\arguments{
\item{from}{The lower bound of the sequence}

\item{to}{The higher bound of the sequence}
}
\value{
A sequence ranging from \code{from} to \code{to}
}
\description{
The \code{\link[=zeq]{zeq()}} function creates an increasing integer sequence, but differs from
the standard one in that it will not silently generate a decreasing sequence
when the second argument is smaller than the first. If the second argument is
one smaller than the first it will generate an empty sequence, if the
difference is greater, the function will throw an error.
}
\examples{
# For increasing sequences, zeq() and seq() are identical
zeq(11,15)
zeq(11,11)

# If second argument equals first-1, an empty sequence is returned
zeq(11,10)

# If second argument is less than first-1, the function throws an error
tryCatch(zeq(11,9), error=wrap_error)

}
