% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{upload_forecast}
\alias{upload_forecast}
\title{Upload a forecast}
\usage{
upload_forecast(
  zoltar_connection,
  model_url,
  timezero_date,
  forecast_data,
  is_json = TRUE,
  notes = ""
)
}
\arguments{
\item{zoltar_connection}{A \code{ZoltarConnection} object as returned by \code{\link[=new_connection]{new_connection()}}}

\item{model_url}{URL of a model in zoltar_connection's projects}

\item{timezero_date}{The date of the project timezero you are uploading for. it is a string in format YYYYMMDD}

\item{forecast_data}{Forecast data to upload data to upload, either a \code{list} (if is_json==TRUE) or a \code{dataframe}
otherwise. formats are documented at https://docs.zoltardata.com/}

\item{is_json}{TRUE if forecast_data is JSON (list) format, and FALSE if it is CSV (dataframe) format}

\item{notes}{Optional user notes for the new forecast}
}
\value{
A Job URL for the upload
}
\description{
This function submits forecast data to the server for uploading. Returns a Job object that can be used to
up, which depends on the number of current uploads in the queue. Zoltar tracks these via \code{Job} objects.)
}
\examples{
\dontrun{
  forecast_data <- jsonlite::read_json("docs-predictions.json")
  job_url <- upload_forecast(conn, "http://www.zoltardata.com/api/model/1/",
                             "2017-01-17", forecast_data, TRUE, "a mid-January forecast")
}
}
