% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopriEndpt.R
\name{TwoGrpCopriEndpt.SimPower}
\alias{TwoGrpCopriEndpt.SimPower}
\title{Power Simulation for Two Group Two Coprimary Endpoints Group Sequential Design.}
\usage{
TwoGrpCopriEndpt.SimPower(mu11,mu12, mu21, mu22, rho, tau,
 alpha1, alpha2, alternative , Nmax, B)
}
\arguments{
\item{mu11}{standardized mean value for coprimary endpoint 1 in group 1.}

\item{mu12}{standardized mean value for coprimary endpoint 2 in group 1.}

\item{mu21}{standardized mean value for coprimary endpoint 1 in group 2.}

\item{mu22}{standardized mean value for coprimary endpoint 2 in group 2.}

\item{rho}{correlation coefficient between two coprimary endpoints.}

\item{tau}{information time for the interim analysis.}

\item{alpha1}{significant level for the first stage.}

\item{alpha2}{significant level for the second stage.}

\item{alternative}{indicates the alternative hypothesis and must be one of \code{"two.sided"} or \code{"two.sided"}.}

\item{Nmax}{maximum sample size per group.}

\item{B}{the simulation iterative time.}
}
\value{
The evaluated power with attributes and computational error.
}
\description{
Given the group sequential design information, returns the simulated overall power.
}
\examples{
# Example in Chang (2014) page  275
TwoGrpCopriEndpt.SimPower(mu11=0.2,mu12=0.25, mu21=0.005, mu22=0.015, rho=0.25,
tau=0.5, alpha1=0.0025, alpha2=0.024, alternative = "two.sided",Nmax=584, B=10000)
}
\author{
Yalin Zhu
}
\references{
Chang, M. (2014). Adaptive design theory and implementation using SAS and R.
\emph{CRC Press}.
}

