% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahm.R
\name{coef.ahm}
\alias{coef.ahm}
\title{Coefficient method for the fitted ahm object}
\usage{
\method{coef}{ahm}(object, ...)
}
\arguments{
\item{object}{ahm object}

\item{...}{not used}
}
\value{
a numerical vector
}
\description{
Coefficient method for the fitted ahm object
}
\examples{
data("pringles_fat")
data_fat = pringles_fat
h_tmp = 1.3
x = data_fat[,c("c1","c2","c3","x11","x12","x21","x22")]
y = data_fat[,1]
out = ahm (y, x, num_major = 3, dist_minor = c(2,2,1),
           type = "weak", alpha=0, lambda_seq=seq(0,5,0.01), nfold = NULL,
           mapping_type = c("power"), powerh = h_tmp,
           rep_gcv=100)
coef(out)

}
