% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahm.R
\name{predict.ahm}
\alias{predict.ahm}
\title{Predict method for the fitted ahm object}
\usage{
\method{predict}{ahm}(object, newx, ...)
}
\arguments{
\item{object}{ahm object}

\item{newx}{Matrix of new values for x at which predictions are to be made.}

\item{...}{not used}
}
\value{
predicted value(s) at newx
}
\description{
Predict method for the fitted ahm object
}
\examples{
data("pringles_fat")
data_fat = pringles_fat
h_tmp = 1.3
x = data_fat[,c("c1","c2","c3","x11","x12","x21","x22")]
y = data_fat[,1]
out = ahm (y, x, num_major = 3, dist_minor = c(2,2,1),
           type = "weak", alpha=0, lambda_seq=seq(0,5,0.01), nfold = NULL,
           mapping_type = c("power"), powerh = h_tmp,
           rep_gcv=100)
predict(out)

}
