#' Alfalfa water requirement for land evaluation
    #' 
    #' A dataset containing the water characteristics of the crop requirements for farming Alfalfa.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item CropLen - Length of growing period (days)
#' \item WgAv - Precipitation of growing cycle (mm)
#' \item WghAv - Relative humidity growing cycle (\%)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 3 rows and 8 columns
#' @name ALFALFAWater
NULL