#' Castor Beans soil requirement for land evaluation
    #' 
    #' A dataset containing the soil characteristics of the crop requirements for farming Castor Beans.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item CFragm - Coarse fragment (Vol.\%)
#' \item SoilDpt - Soil depth (cm)
#' \item CECc - Apparent CEC Clay (cmol (+)/kg clay)
#' \item BS - Base Saturation (\%)
#' \item SumBCs - Sum of basic caions (cmol (+)/kg soil)
#' \item pHH2O - pH H2O
#' \item OC - Organic carbon (\%)
#' \item ECedS - ECe (dS/m)
#' \item ESP - ESP (\%)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 9 rows and 8 columns
#' @name BEANCASoil
NULL