#' Beans water requirement for land evaluation
    #' 
    #' A dataset containing the water characteristics of the crop requirements for farming Beans.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item WgAv - Precipitation of growing cycle (mm)
#' \item WmhAv2 - Relative humidity of devel. Stage (\%)
#' \item WmhAv3 - Relative humidity of maturation Stage (\%)
#' \item WmnN2 - n/N develop. Stage (2nd month)
#' \item WmnN4 - n/N maturation stage (4th month)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 5 rows and 8 columns
#' @name BEANSWater
NULL