#' Coconut soil requirement for land evaluation
    #' 
    #' A dataset containing the soil characteristics of the crop requirements for farming Coconut.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item CFragm - Coarse fragment (Vol.\%)
#' \item SoilDpt - Soil depth (cm)
#' \item BS - Base Saturation (\%)
#' \item SumBCs - Sum of basic caions (cmol (+)/kg soil)
#' \item OC - Organic carbon (\%)
#' \item ECemh - ECe (mmhos/cm)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 6 rows and 8 columns
#' @name COCONUTSoil
NULL