#' Rainfed Upland Rice terrain requirement for land evaluation
    #' 
    #' A dataset containing the terrain characteristics of the crop requirements for farming Rainfed Upland Rice.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item Slope1 - Slope (\%) (1. Irrigrated agriculture, basin furrow irrigation)
#' \item Slope2 - Slope (\%) (2. High level of managemnet with full mechanization. )
#' \item Flood - Flooding
#' \item Drainage4 - Drainage (Medium and fine textured soils)
#' \item Drainage5 - Drainage (Coarse textured soils - Sandy families)
#' \item SlopeD - Slope (degree, 6 classes)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 6 rows and 8 columns
#' @name RICEURTerrain
NULL