% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_3_table_1}
\alias{chapter_3_table_1}
\alias{C3T1}
\alias{Chapter_3_Table_1}
\alias{c3t1}
\title{The data used in Chapter 3, Table 1}
\format{
An object of class \code{data.frame} with 6 rows and 1 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_3_table_1)
}
\description{
Hyperactive children's IQ scores from the WISC-R
}
\details{
Assume that you work in the research office of a large school system. For the last several years, the mean score on the WISC-R, which is administered to all elementary school children in your district, has been holding fairly steady at about 98. A parent of a hyperactive child in one of your special edication programs maintains that the hyperactive children in the district are actually brighter than this average. To investigate this assertion, you randomly select the files of six hyperactive children and examine their WISC-R scores. The data set analyzed to replicate Chapter 3 Table 1 consists of IQ (WISC-R) measurements on six hyperactive children. The question of interest is: "are hyperactive children in the school district brighter than the average student?" The mean IQ among the students is known to be 98. Thus, the null hypothesis in this situation is that the population mean for the hyperactive students is also 98. To answer such a question we perform a one sample \emph{t}-test specifying the value of the null hypothesis as 98. Because a t-value squared with df degrees of freedom is equivalent to an \emph{F}-value with one numerator and \emph{df} denominator degrees of freedom. Recall that the observed \emph{F}-value (with 1 and 5 degrees of freedom) in the book is 9, whereas our \emph{t}-value (with 5 degrees of freedom) is 3.
}
\section{Variables}{

\describe{
\item{iq}{IQ score from the WISC-R}}
}

\section{Synonym}{

C3T1
}

\examples{
# Load the data
data(chapter_3_table_1)

# Or, alternatively load the data as
data(C3T1)

# View the structure
str(chapter_3_table_1)

}
\references{
Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
