% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimalExamples.R
\docType{data}
\name{minimalExamples}
\alias{minimalExamples}
\alias{minimalBSExample}
\alias{twoWayExample}
\alias{minimalWSExample}
\alias{twoWayWithinExample}
\alias{minimalMxExample}
\alias{minimalMxExampleCompiled}
\title{A collection of minimal Examples from various designs with one or two factors.}
\format{
Objects of class data.frame:

An object of class \code{data.frame} with 6 rows and 4 columns.

An object of class \code{data.frame} with 19 rows and 3 columns.

An object of class \code{data.frame} with 30 rows and 6 columns.

An object of class \code{data.frame} with 27 rows and 5 columns.

An object of class \code{data.frame} with 4 rows and 5 columns.
}
\usage{
minimalBSExample

twoWayExample

minimalWSExample

twoWayWithinExample

minimalMxExample

minimalMxExampleCompiled
}
\description{
The datasets present minimal examples that are analyzed with an
Analysis of Frequency Data method (described in \insertCite{lc23;textual}{ANOPA}.
The five datasets are
\itemize{
\item \code{minimalBSExample}: an example with a single factor (state of residency)
\item \code{twoWayExample}: an example with two factors, Class and Difficulty
\item \code{minimalWSExample}: an example with a within-subject design (three measurements)
\item \code{twoWayWithinExample}: an example with two within-subject factors
\item \code{minimalMxExample}: a mixed design having one within and one between-subject factors
\item \code{minimalMxExampleCompiled}: a mixed design having one within and one
between-subject factors but available in a compiled format (more compact).
}
}
\examples{
library(ANOPA)

# the twoWayExample data with proportions per Classes and Difficulty levels 
twoWayExample

# perform an anopa on this dataset
w <- anopa( {success;total} ~ Difficulty * Class, twoWayExample) 

# We analyse the proportions by Difficulty for each Class
e <- emProportions(w, ~ Difficulty | Class)

}
\references{
\insertAllCited{}
}
\keyword{datasets}
