% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_cohesion.R
\name{calc_cohesion}
\alias{calc_cohesion}
\title{Calculate Neighborhood Cohesion Score}
\usage{
calc_cohesion(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `cohesion`, where `cohesion`
is the calculated cohesion score for each participant. Participants who did not answer
all four questions will have an NA score.
}
\description{
This function computes a neighborhood cohesion score ranging from 1 to 5 based on
survey responses. The score is the mean of four specific item scores, where higher
scores indicate greater neighborhood cohesion.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 1, 2, 2, 3, 3, 4, 4),
  question_concept_id = c(40192463, 40192411, 40192463, 40192411,
                          40192499, 40192417, 40192499, 40192417),
  answer_concept_id = c(40192514, 40192455, 40192524, 40192408,
                        40192514, 40192524, 40192408, 40192422)
)

# Compute neighborhood cohesion scores
cohesion_scores <- calc_cohesion(survey_df)
head(cohesion_scores)

}
